import os
from llama_index.core import VectorStoreIndex, SimpleDirectoryReader
from llama_index.core import Settings
from llama_index.llms.openai import OpenAI
from dotenv import load_dotenv

load_dotenv()

# Initialize OpenAI
Settings.llm = OpenAI(model="gpt-4o", temperature=0.7)

def initialize_index():
    # Check if knowledge base exists
    if not os.path.exists('knowledge.txt'):
        return None
    
    documents = SimpleDirectoryReader(input_files=['knowledge.txt']).load_data()
    index = VectorStoreIndex.from_documents(documents)
    return index

_index = None

def get_query_engine():
    global _index
    if _index is None:
        _index = initialize_index()
    
    if _index:
        return _index.as_query_engine()
    return None

def query_knowledge_base(query_text):
    query_engine = get_query_engine()
    if query_engine:
        response = query_engine.query(query_text)
        return str(response)
    return "I don't have access to my knowledge base right now."
