import os
import requests
from dotenv import load_dotenv

load_dotenv()

DID_API_KEY = os.getenv("DID_API_KEY")

print(f"Testing D-ID API with key: {DID_API_KEY[:20]}...")

# Test 1: Check API Key validity
url = "https://api.d-id.com/talks"
headers = {
    "Authorization": f"Basic {DID_API_KEY}",
    "Content-Type": "application/json"
}

# Try to get talks (should return 200 even if empty)
response = requests.get(url, headers=headers)
print(f"\n1. API Key Test:")
print(f"   Status: {response.status_code}")
print(f"   Response: {response.text[:200]}")

if response.status_code == 401:
    print("   ❌ FAILED: Invalid API Key or Unauthorized")
elif response.status_code == 200:
    print("   ✅ SUCCESS: API Key is valid")
else:
    print(f"   ⚠️  Unexpected status: {response.status_code}")

# Test 2: Check credits
print(f"\n2. Checking D-ID Credits...")
credits_url = "https://api.d-id.com/credits"
credits_response = requests.get(credits_url, headers=headers)
print(f"   Status: {credits_response.status_code}")
if credits_response.status_code == 200:
    print(f"   Credits: {credits_response.json()}")
else:
    print(f"   Response: {credits_response.text}")
