import os
import requests
from dotenv import load_dotenv
import base64

load_dotenv()
DID_API_KEY = os.getenv("DID_API_KEY")

# Test with minimal audio
test_audio = "Hello, this is a test."
audio_base64 = base64.b64encode(test_audio.encode()).decode()

url = "https://api.d-id.com/talks"

# Try different presenter configurations
configs = [
    {
        "name": "Stock Presenter (amy)",
        "payload": {
            "presenter_id": "amy-jcwCkr1grs",
            "script": {
                "type": "text",
                "input": "Hello, this is a test of the D-ID integration."
            }
        }
    },
    {
        "name": "Default Driver",
        "payload": {
            "script": {
                "type": "text",
                "input": "Hello, this is a test of the D-ID integration."
            },
            "presenter_id": "amy-jcwCkr1grs"
        }
    }
]

headers = {
    "Authorization": f"Basic {DID_API_KEY}",
    "Content-Type": "application/json"
}

for config in configs:
    print(f"\n{'='*60}")
    print(f"Testing: {config['name']}")
    print(f"{'='*60}")
    
    response = requests.post(url, json=config['payload'], headers=headers)
    print(f"Status: {response.status_code}")
    print(f"Response: {response.text[:500]}")
    
    if response.status_code == 201:
        print("✅ SUCCESS!")
        break
    else:
        print("❌ FAILED")
