import os
import sys
import django
import asyncio

# Setup Django
sys.path.append(os.path.dirname(os.path.abspath(__file__)))
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'agent_project.settings')
django.setup()

from agent.video_engine import render_video, generate_audio
from django.conf import settings
import time

async def test_full_pipeline():
    print("=" * 70)
    print("TESTING AI VIDEO AGENT - FULL PIPELINE")
    print("=" * 70)
    
    # 1. Generate test audio
    print("\n1️⃣  Generating test audio...")
    test_text = "Hello! This is a test of the AI video agent with D-ID integration."
    audio_path = await generate_audio(test_text, 'en', 'test_audio_final.mp3')
    print(f"✅ Audio generated: {audio_path}")
    
    # 2. Test video generation with D-ID
    print("\n2️⃣  Testing D-ID video generation...")
    avatar_path = os.path.join(settings.BASE_DIR, 'agent', 'static', 'avatar.png')
    
    start_time = time.time()
    video_result = render_video(audio_path, avatar_path, 'test_video_final.mp4')
    end_time = time.time()
    
    print(f"\n⏱️  Total time: {end_time - start_time:.2f} seconds")
    
    if video_result.startswith('http'):
        print(f"\n✅ SUCCESS! D-ID video URL: {video_result}")
        print("\n🎉 The integration is working!")
        print("You should see a talking avatar with lip-sync.")
    else:
        print(f"\n⚠️  Fallback used: {video_result}")
        print("D-ID integration failed, using static video.")
    
    print("\n" + "=" * 70)

if __name__ == "__main__":
    asyncio.run(test_full_pipeline())
