import requests
import time

def test_generate_video():
    url = "http://127.0.0.1:8004/generate_video/"
    data = {
        "text": "Hello, this is a test of the video generation system.",
        "lang": "en"
    }
    
    print(f"Sending request to {url}...")
    start_time = time.time()
    try:
        response = requests.post(url, json=data)
        end_time = time.time()
        
        print(f"Status Code: {response.status_code}")
        
        if response.status_code != 200:
            with open("error.html", "w", encoding="utf-8") as f:
                f.write(response.text)
            print("Saved error response to error.html")
            
            # Try to extract exception value simply
            if "exception_value" in response.text:
                start = response.text.find("exception_value")
                end = response.text.find("</pre>", start)
                print(f"Exception Value: {response.text[start:end]}")

        print(f"Time taken: {end_time - start_time:.2f} seconds")
        
        if response.status_code == 200:
            print("Success!")
        else:
            print("Failed!")
            
    except Exception as e:
        print(f"Exception: {e}")

if __name__ == "__main__":
    test_generate_video()
