import os
import sys
import django
import asyncio
from django.conf import settings

# Setup Django environment
sys.path.append(os.path.dirname(os.path.abspath(__file__)) + '/../')
os.environ.setdefault('DJANGO_SETTINGS_MODULE', 'agent_project.settings')
django.setup()

from agent.video_engine import generate_audio, generate_subtitles, render_video

async def test_pipeline():
    print("1. Testing Audio Generation (EdgeTTS)...")
    text = "Hello, this is a test of the video agent."
    audio_path = await generate_audio(text, 'en', 'test_audio.mp3')
    if os.path.exists(audio_path):
        print(f"   [PASS] Audio generated: {audio_path}")
    else:
        print("   [FAIL] Audio file not found")
        return

    print("2. Testing Subtitle Generation...")
    # Mock duration
    duration = 3.5
    sub_path = generate_subtitles(text, duration, 'test_sub.vtt')
    if os.path.exists(sub_path):
        print(f"   [PASS] Subtitles generated: {sub_path}")
        with open(sub_path, 'r') as f:
            print(f"   Content preview:\n{f.read()}")
    else:
        print("   [FAIL] Subtitle file not found")

    print("3. Testing Video Rendering (MoviePy)...")
    avatar_path = os.path.join(settings.BASE_DIR, 'agent', 'static', 'avatar.png')
    if not os.path.exists(avatar_path):
        print(f"   [WARN] Avatar not found at {avatar_path}, using placeholder if possible or failing.")
    
    try:
        video_path = render_video(audio_path, avatar_path, 'test_video.mp4')
        if os.path.exists(video_path):
            print(f"   [PASS] Video generated: {video_path}")
        else:
            print("   [FAIL] Video file not found")
    except Exception as e:
        print(f"   [FAIL] Video rendering failed: {e}")

if __name__ == "__main__":
    asyncio.run(test_pipeline())
